﻿using UnityEngine;
using System.Collections;
using UnityEngine.UI;
public class MusicBtnListener : MonoBehaviour {
    public Button bplay;
    public Button bnext;
    public Button blist;
    public Button bsound;
    public Button bbackMenu;

    public GameObject MusicPlayer;
    public GameObject MusicList;
    private bool setSound = false;
    private bool showList = false;
	public int indx = 0;
	public AudioClip[] ac;
	private AudioSource audios;
         
	// Use this for initialization
	void Start () {
        blist.onClick.AddListener(OnListBtnClick);
        bplay.onClick.AddListener(OnPlayBtnClick);
        bsound.onClick.AddListener(OnSoundBtnClick);
        bbackMenu.onClick.AddListener(OnListBtnClick);
        bnext.onClick.AddListener(OnNextBtnClick);
		ac = this.GetComponent<MusicListBtnListener> ().ac;
		audios = this.GetComponent<AudioSource> ();
	}
	
	// Update is called once per frame
	void Update () {
		Debug.Log (audios.isPlaying);
	}
    void OnListBtnClick()
    {
        showList = !showList;
        MusicList.SetActive(showList);
    }
    void OnNextBtnClick() {
        indx++;
        audios.clip = ac[indx];
        audios.Play();
    }
    void OnPlayBtnClick()
    {
		audios.clip = ac[indx];
		
        if (audios.isPlaying) {
            audios.Pause();
        } else {
            audios.Play();
        }

        
    }

    void OnSoundBtnClick()
    {
        setSound = !setSound;
        bsound.transform.GetChild(0).gameObject.SetActive(setSound);//开启/关闭 背景遮罩
        bsound.transform.GetChild(1).gameObject.SetActive(setSound);//开启/关闭 音量滑块
        //Debug.Log("Sound bt click");
    }

}
