import json

import config
import requests
import http.cookiejar

# !/usr/bin/env python3
# -*- coding: utf-8 -*-
conf = config.redConf()
headers = {
    'User-Agent': 'Mozilla/5.0 (Linux; Android 10; Redmi K30 Build/QKQ1.190825.002; wv) AppleWebKit/537.36 ('
                  'KHTML, like Gecko) Version/4.0 Chrome/80.0.3987.99 Mobile Safari/537.36 okhttp/3.12.4 ',
    'CpdailyStandAlone': '0',
    'extension': '1',
    'Content-Type': 'application/json; charset=utf-8',
    'Accept-Encoding': 'gzip, deflate',
    'Accept-Language': 'zh-CN,zh;q=0.9,en-US;q=0.8,en;q=0.7',
    'Accept': 'application/json, text/plain, */*',
    'Cpdaily-Extension': conf['user']['Cpdaily-Extension']

}



def main():
    cookies = login()
    if cookies is None:
        print('获取cookie失败')
        return
    datas = queryCollector(cookies)
    if datas is None:
        return
    extraFieldItems = fillForm(datas['extraFieldItems'])
    datas['extraFieldItems'] = extraFieldItems
    print(json.dumps(datas))
    submitForm(cookies, datas)


# 生成提交信息
def fillForm(extraFields):
    fillItem = [];
    for extraField in extraFields:
        extraFieldItems = extraField['extraFieldItems']
        for fieldItem in extraFieldItems[::-1]:
            if not fieldItem['isAbnormal']:
                item = {'extraFieldItemValue': fieldItem['content'], 'extraFieldItemWid': fieldItem['wid']}
                fillItem.append(item)


    return fillItem


##登录获取cookie
def login():
    ##从配置文件中读取需要的数据
    data = {
        'username': conf['user']['user_num'],
        'password': conf['user']['password'],
    }
    headers = {
        'Accept': 'application/json, text/plain, */*',
        'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8'
    }

    loginUrl = 'http://cpdaily.lmyd.xyz/api/login'
    ##提交登录请求
    res = requests.post(loginUrl, data=data)
    datas = res.json()['cookies']
    cookies = {
    }
    if datas is None:
        print('获取cookie失败，请检查用户名密码')
        return None

    ##将cookie的原始数据格式化为字典
    for line in datas.split(';'):
        name, value = line.strip().split('=', 1)
        cookies[name] = value
    return cookies


##查询今日待填表单数据,填写后返回
def queryCollector(cookies):
    datas = {}

    res = requests.post(url=conf['api']['query_collector_url'],
                        headers=headers, cookies=cookies, data=json.dumps(datas))
    datas = res.json()
    if len(datas['datas']['unSignedTasks']) < 1:
        print('暂无可提交表单')
        return None

    stuSignWid = datas['datas']['unSignedTasks'][0]['stuSignWid']
    signInstanceWid = datas['datas']['unSignedTasks'][0]['signInstanceWid']
    signWid = datas['datas']['unSignedTasks'][0]['signWid']
    #获取温度提交选项详细信息
    res = requests.post(url=conf['api']['detail_form_url'], headers=headers, cookies=cookies,
                        data=json.dumps({'signInstanceWid': signInstanceWid, 'signWid': signWid}))
    datas = res.json()
    if datas is None:
        print('获取表单基本信息失败')
        return
    signedStuInfo = datas['datas']['signedStuInfo']
    ##签到状态
    signStatus = datas['datas']['signStatus']

    isNeedExtra = datas['datas']['isNeedExtra']
    isMalposition = datas['datas']['isMalposition']
    signPhotoUrl = datas['datas']['signPhotoUrl']
    ##获取签到点信息
    signPlaceSelected = datas['datas']['signPlaceSelected'][0]
    ##从signPlaceSelected中读取基点经纬度
    longitude = signPlaceSelected['longitude']
    latitude = signPlaceSelected['latitude']
    ##获取偏移范围(以基点为中心的可签到范围)
    radius = signPlaceSelected['radius']
    ##获取选项id及选项信息
    extraField = datas['datas']['extraField']
    ##构造数据并返回
    return {
        "signInstanceWid": signInstanceWid,
        "longitude": conf['user']['longitude'],
        "latitude": conf['user']['latitude'],
        "isMalposition": isMalposition,
        "abnormalReason": "",
        "signPhotoUrl": signPhotoUrl,
        'position': conf['user']['address'],
        'isNeedExtra': isNeedExtra,
        'extraFieldItems': extraField
    }



##提交温度签到
def submitForm(cookie, datas):
    headers['host'] = 'abc.cpdaily.com'
    res = requests.post(url=conf['api']['submit_sign_url'], headers=headers,
                        cookies=cookie, data=json.dumps(datas))
    print(res.json()['message'])
    return


if __name__ == '__main__':
    main()
